$.noConflict(true)(function($)
{
	// Define some variables
	var ftd = $(document),
		thisImage = $('img[name="sample"]'),
		regions = $('[name^="region["]'),
		paused = false;
	
	thisImage.on('click', function(e)
	{
		if ($(this).attr('data-clickable') == 0)
		{
			// Not clickable
			return false;
		}
		
		// Detext the X and Y offsets
		var parentOffset = $(this).parent().offset();
		
		// Set the regions
		$('input[name="region[xcoord]"]').val(parseInt(e.pageX - parentOffset.left));
		$('input[name="region[ycoord]"]').val(parseInt(e.pageY - parentOffset.top));
		
		updateRegionPreview();
	});	
	
	$('input[name="preview"]').on('click', 				updateRegionPreview);	
	$('select[name="region[fontsize]"]').on('change', 	updateRegionPreview);	
	$('select[name="region[fontweight]"]').on('change', updateRegionPreview);	
	//regions.on('keyup', 								updateRegionPreview);	
	
	// Trigger this
	updateRegionPreview();
	
	// #########################################################################
	// Updates the region preview
	function updateRegionPreview(e)
	{
		if (paused)
		{
			// Stop this
			return true;
		}
		
		var extraParams = {};
		
		regions.each(function(index, element)
		{
			var thisElem = $(this);
			
			// Set the param
			extraParams[thisElem.attr('name')] = thisElem.val();
		});
		
		// Just do the preview xD
		ajaxCall('regionpreview', extraParams);
	}
	
	// #########################################################################
	// Shorthand for an ajax call
	function ajaxCall(varname, extraParams, type)
	{
		paused = true;
		
		if (typeof type == 'undefined')
		{
			// Ensure we're setting this correctly
			type = 'POST';
			extraParams['securitytoken'] = SECURITYTOKEN;
		}
		
		// Set additional global params
		extraParams['do'] = 'ajax';
		extraParams['action'] = varname;
		extraParams['signaturestyleid'] = thisImage.attr('data-styleid');

		// Add random garble to avoid IE bug
		extraParams['v'] = Math.random() * 99999999999999;
		
		$.ajax({
			type: type,
			url: '../vbsignatures.php',
			data: (SESSIONURL ? SESSIONURL + '&' : '') + $.param(extraParams)
		})
		.done(function(data)
		{
			// Unpause
			paused = false;
			
			if (data.error)
			{
				// Log the error to the console
				console.error(timeStamp() + "AJAX Error: %s", data.error);
				
				return true;		
			}
						
			if (typeof data.dosave != 'undefined')
			{
				// Emulate a click of the save button
				$('input[name="saveavatar"]').trigger('click');
			}
						
			if (typeof data.img != 'undefined')
			{
				thisImage.attr('src', data.img + '?v=' + Math.random() * 99999999999999);
			}			
		})
		.fail(function(data, textStatus)
		{
			// Unpause
			paused = false;
			
			try
			{
				if (data.statusText == 'communication failure' || data.statusText == 'transaction aborted' || data.status == 0)
				{
					// Ignore this error
					return false;
				}
				
				// Log the error to the console
				console.error(timeStamp() + "AJAX Error: Status = %s: %s", data.status, data.statusText);
			}
			catch (e)
			{
				// Log the error to the console
				console.error(timeStamp() + "AJAX Error: %s", data.responseText);
			}
		});
	};
	
	// #########################################################################
	// Debugging function, generates a timestamp of when something occurred
	function timeStamp()
	{
		var d = new Date();
		
		return '[' + d.getHours() + ':' + d.getMinutes() + ':' + d.getSeconds() + '] ';
	};	
});